#include "Standards.h"
#include "math.h"

#ifndef def_cstone

#define def_cstone

class CStone
{
public:
    Point pos;
    Vector move;
    //Rect bounding;
    int exist;
    float cos_a;
    float vi,vf;    //initial and final velocities
    float mass,elac;
    float power;
    float angle;
    float curl_angle;
    float lx,ly;        //position for locked mouse pos
    bool locked;

    float curl_stepsize;
    float rock_angle;
    int curl_degrees;

    int radius;
    RGB *colour;
    BITMAP *pic;
    int owner;
    bool shot;

    void init_stone(void);
    void create_stone(float _x, float _y, BITMAP *_pic, int _owner);
    void draw_stone(BITMAP *backgr, float s_x, float s_y);
    void draw_stone(BITMAP *backgr, float s_x, float s_y, float w, float h);
    int move_stone(float friction, Point *screen_pos);
    float check_coll_with_stone(CStone *stone);
    float calc_col_angle(CStone *stone);
    void calc_new_vector(CStone *stone);
    void shoot(float angle,float _power);
    void shoot(Point *mouse_pos);

    void get_shot_angle(Point *mouse_pos);
    void draw_shot(BITMAP *backgr, BITMAP *zoom, float s_x, float s_y,Point *mouse_pos);

    void destroy_stone(void);
    int is_moving(void);
    void check_bounds(int x);
};

void CStone::check_bounds(int x)
{
    if(pos.x + pic->w/2 < x && move.dx==0 && move.dy==0 && pos.x>670)
        {
        //it's not over the hog line, and it's stopped
        exist=0;
        }
}

int CStone::is_moving(void)
{
    if(exist==1)
    {
    if(move.dx==0 && move.dy==0)
        return 0;  //if it is not moving, return 0
    else
        return 1;   //if it is moving, return 1
    }
    else
        return 0;
}

void CStone::destroy_stone(void)
{
    destroy_bitmap(pic);
}

void CStone::shoot(Point *mouse_pos)
{
    //if(locked==false)
    //    {
        float angle = atan2((int)(pos.y-ly) , (int)(pos.x-lx));

        shoot(angle,power);
    //    }
   // curl_stepsize=power;
}

void CStone::get_shot_angle(Point *mouse_pos)
{
    Point pLocked;
    if(locked==false)
        {
        lx=mouse_pos->x;
        ly=mouse_pos->y;
        curl_degrees=0;
        }
    if((mouse_b & 2) && locked==false )
        {
        rest(10);
        locked=true;
        }

    else if((mouse_b & 2) && locked==true )
        {
        rest(10);
        locked=false;
        }



    pLocked.x=lx;
    pLocked.y=ly;

    if(locked==true)
        {
        curl_degrees = (int)((mouse_pos->y - pos.y)/3)*-1;

        if(curl_degrees<-20)
            curl_degrees=-20;
        else if(curl_degrees>20)
            curl_degrees=20;

        if(curl_degrees < 0 && curl_stepsize>0)
            curl_stepsize*=-1;
        else if(curl_degrees >0 && curl_stepsize<0)
            curl_stepsize*=-1;

        curl_angle = (float)((curl_degrees/2)*(M_PI/180));
        //curl_angle -= M_PI/4;
        }

    /*if(locked==true)
        {
        rock_angle = atan2((int)(pos.y-mouse_pos->x) , (int)(pos.x-mouse_pos->y));
        } */
    /*rock_angle*///curl_stepsize=(curl_degrees * M_PI)/180;

    power=get_dist(&pos,&pLocked)/20;
    power+=12;
    angle = atan2((int)(pos.y-ly) , (int)(pos.x-lx));
}


void CStone::draw_shot(BITMAP *backgr, BITMAP *zoom, float s_x, float s_y,Point *mouse_pos)
{
    float mpx,mpy,rx,ry;  //screen pos of mouse and rock
    //int curl_degrees=0;
    //float power;
    if(exist==1)
        {
        //mpx = mouse_pos->x - s_x;
        //mpy = mouse_pos->y - s_y;
        mpx = lx-s_x;
        mpy = ly-s_y;
        rx = pos.x - s_x;
        ry = pos.y - s_y;

        line(backgr,(int)rx,(int)ry-radius,(int)(rx+(cos(curl_angle*2)*50)),(int)(ry+(sin(curl_angle*2)*50)),makecol(0,0,0));
        line(backgr,(int)rx,(int)ry+radius,(int)(rx+(cos(curl_angle*2)*50)),(int)(ry+(sin(curl_angle*2)*50)),makecol(0,0,0));

        line(backgr,(int)(mpx),(int)(mpy),(int)(rx),(int)(ry),makecol(0,255,0));
        line(backgr,(int)(rx),(int)(ry),(int)(rx+cos(angle)*(3800)),(int)(ry+sin(angle)*(3800)),makecol(0,255,255));


        for(int n=-2 ; n<2 ; n++)
           line(zoom,(int)(-(rink_width-zoom->w)),(int)pos.y+n,(int)(-(rink_width-zoom->w)+cos(angle)*3700),(int)(pos.y+n+sin(angle)*3700),makecol(0,255,255));

        textprintf(backgr,font,mouse_x-30,mouse_y+20,makecol(255,0,0),"Power %d",(int)(power*10));
        textprintf(backgr,font,mouse_x-30,mouse_y+35,makecol(255,0,0),"Curl %d",curl_degrees);

        }
}

void CStone::shoot(float angle,float _power)
{
    vi=0;
    //angle/=180;
    //angle*=M_PI;
    move.dx = cos(angle) * _power;
    move.dy = sin(angle) * _power;

    shot=true;
}



int CStone::move_stone(float friction, Point *screen_pos)
{
    int ret=0;      //normally returns zero
    float move_angle;
    float xspeed=0, yspeed=0;
    float speed=0,dx,dy;

    if(exist==1)
        {
        if(move.dx<=14)
            {
            /*if(move.dx!=0)
                {
                pos.x +=(cos(curl_angle)*curl_stepsize);
                }  */

            if(move.dy!=0 || move.dx!=0)
                {
                pos.y +=(sin(curl_angle)*abval(curl_stepsize));
                }
            }

        //move.dx*=friction;
        //move.dy*=friction;

        move_angle = atan2(move.dy,move.dx);

        dx = cos(move_angle);
        dy = sin(move_angle);

        //speed = move.dx / dx;

        speed = sqrt( move.dx*move.dx + move.dy*move.dy);
        //speed *= move.dx / dx;

        if(move.dx!=0 || move.dy!=0)
            {
            speed-=friction;
            }
        else
            speed=0;

        move.dx = dx*speed;
        move.dy = dy*speed;

        pos.x +=move.dx;
        pos.y +=move.dy;

        //curl_stepsize/=(friction*2);
        curl_stepsize*=.9982;

        if(pos.x>rink_width)
            exist=0;
        if(pos.y-radius < -screen_pos->y)
            exist=0;
        else if(pos.y+radius > -screen_pos->y+434)
            exist=0;

        if(exist==0)
            ret=1; //returns 1 if the rock went out of bounds

        if(shot==true)  //if this rock is the current shot
            {
            /*if(pos.x > screen_pos->x+75)
                screen_pos->x += move.dx;*/
            screen_pos->x = pos.x - 320;

            if((move.dx<=0.1 && move.dy<=0.1 && move.dx>=-0.1 && move.dy>=-0.1) || abval(speed)<=friction)
                {
                shot=false;
                locked=false;

                move.dx=0;
                move.dy=0;
                speed=0;
                }
            }

            if(move.dx<=0.01 && move.dx>=-0.01)
                move.dx=0;
            if(move.dy<=0.01 && move.dy>=-0.01)
                move.dy=0;

           /* while(move.dx>1)
                {
                xspeed++;
                move.dx/=1;
                }
            while(move.dy>1)
                {
                yspeed++;
                move.dy/=1;
                } */
            /*xspeed = sqrt(move.dx*move.dx + move.dy*move.dy);

            move_angle=atan2(move.dy,move.dx);   */
            if((move.dx!=0 || move.dy!=0) && curl_angle!=0)    //if the rock is moving
                {
                //move.dx = cos(move_angle)*xspeed;
                //move.dx = sin(move_angle)*xspeed;
                rock_angle+=curl_stepsize;  //rotate it
                }

        }
    return ret;

}

void CStone::create_stone(float _x, float _y, BITMAP *_pic, int _owner)
{
    init_stone();   //reset all the values
    exist=1;

    pos.x = _x;
    pos.y = _y;
    pic = _pic;
    owner = _owner;
}

void CStone::draw_stone(BITMAP *backgr, float s_x, float s_y)
{
    if(exist==1)
        {
        if((int)pos.x-(int)(s_x-pic->w/2)>0 && (int)pos.x-(int)(s_x-pic->w/2<800) &&
           (int)pos.y-(int)(s_y-pic->h/2)>0 && (int)pos.y-(int)(s_y-pic->h/2<600))
            {
            rotate_sprite(backgr,pic,(int)pos.x-(int)s_x-pic->w/2,(int)pos.y-(int)s_y-pic->h/2,ftofix(rock_angle));
            }
        }
}

void CStone::draw_stone(BITMAP *backgr, float s_x, float s_y, float w, float h)
{
    if(exist==1)
        {
        if(((pos.x-s_x)*w)-((pic->w*w)/2)>0 && ((pos.x-s_x)*w)-((pic->w*w)/2)<800 &&
           ((pos.y-s_y)*h)-((pic->h*h)/2)>0 && ((pos.y-s_y)*h)-((pic->h*h)/2)<600)
            stretch_sprite(backgr,pic,(int)((pos.x-s_x)*w)-(int)((pic->w*w)/2),(int)((pos.y*h-s_y))-(int)((pic->h*h)/2),(int)(pic->w*w),(int)(pic->h*h));
        }
}

void CStone::init_stone(void)
{
    pos.x=0;
    pos.y=0;
    move.dx=0;
    move.dy=0;
    move.length=0;
    move.angle=0;

    radius = 14;    //diameter is 28 pixels or 25 centimeters
    owner=-1;       //means no owner
    shot=false;
    power=0;
    angle=0;
    curl_stepsize=4;
    rock_angle=0;
    curl_angle= /*7*(M_PI/180)*/0;
    lx=0;
    ly=0;
    locked=false;

   /* Point t1;
    t1.x = pos.x - raduis;
    t1.y = pos.y- radius;
    bounding.p1 = t1;
    bounding.p2 = t1;  */
    cos_a=0;
    vi=0;
    vf=0;
    mass = 9.051;  //it weighs 19.051 kg
    elac = 1;

    exist = 0;
}


void CStone::calc_new_vector(CStone *stone)
{
    /*float angle,sina,cosa,odx,ody,ndx,ndy;

    vi=_vi;

    vf=(((mass - stone->mass)*vi)+(((1.0+(elac*stone->elac))*stone->mass)*stone->vi))/(mass+stone->mass);

    angle=atan2(stone->pos.y - pos.y, stone->pos.x - pos.x); // angle of the line connecting the centers
    sina=sin(angle);
    cosa=cos(angle);
    odx=cosa*vi; // subtract off old velocity vector
    ody=sina*vi;
    ndx=cosa*vf; // add on new velocity vector
    ndy=sina*vf;
    move.dx+=odx-ndx; // signs look reversed but are correct
    move.dy+=ody-ndy;

    //pos.x+=move.dx;
    //pos.y+=move.dy;

    //textprintf(screen,font,10,0,makecol(0,0,255),"%f %f",move.dx, move.dy);
    //readkey();    */
    if(exist==1 && stone->exist==1)
        {

    float mye;
    float x2=stone->pos.x, y2=stone->pos.y, r2=stone->radius, dx2=stone->move.dx, dy2=stone->move.dy, m2=stone->mass,  v2=stone->vi, e2=stone->elac;
    float thetac, theta1, theta2;
    float v1c, v1cx, v1cy, v2c, v2cx, v2cy;
    float nv1cx, nv1cy, nv2cx, nv2cy;

    mye  = elac * e2;

   thetac = atan2(y2 - pos.y, x2 - pos.x);      // this is an angle
   theta1 = calc_col_angle(stone);              // this is a cosine
   theta2 = stone->calc_col_angle(this);        // this is a cosine

   v2 = stone->vi;

   v1c = vi * theta1;
   v1cx = v1c * cos(thetac);
   v1cy = v1c * sin(thetac);

   v2c = v2 * theta2;
   v2cx = v2c * cos(thetac+M_PI);
   v2cy = v2c * sin(thetac+M_PI);

   nv1cx = (mass*v1cx + m2*v2cx - mye*m2*(v1cx - v2cx)) / (mass + m2);
   nv1cy = (mass*v1cy + m2*v2cy - mye*m2*(v1cy - v2cy)) / (mass + m2);
   nv2cx = (mass*v1cx + m2*v2cx + mye*mass *(v1cx - v2cx)) / (mass + m2);
   nv2cy = (mass*v1cy + m2*v2cy + mye*mass *(v1cy - v2cy)) / (mass + m2);


    move.dx = (nv1cx + (move.dx - v1cx))  *.80;
    move.dy = (nv1cy + (move.dy - v1cy))  *.80;

    stone->move.dx=(nv2cx + (dx2 - v2cx)) *.70 ;
    stone->move.dy=(nv2cy + (dy2 - v2cy)) *.70 ;

    /*pos.x+=move.dx;
    pos.y+=move.dy;

    stone->pos.x+=stone->move.dx;
    stone->pos.y+=stone->move.dy; */

}

}

float CStone::calc_col_angle(CStone *stone)
{
   float a2, b, c, divisor;
   float temp1, temp2;
   float x2=stone->pos.x, y2=stone->pos.y, r2=stone->radius;

   if ((move.dx == 0) && (move.dy == 0))
      {
      vi = 0;
      return 0;
      }

   temp1 = x2 - (pos.x + move.dx);
   temp2 = y2 - (pos.y + move.dy);
   a2 = temp1*temp1 + temp2*temp2;

   b = radius + r2;

   c = sqrt(move.dx*move.dx + move.dy*move.dy);
   vi = c;

   divisor = -2.0 * b * c;

   return((a2 - b*b - c*c) / divisor);


    //float A,B,C;    //angles
  /*  float a,b,c;    //sides

    float nextx,nexty;
    float cosa1,cosa2;

    if(stone)
    {
    nextx = pos.x + move.dx;
    nexty = pos.y + move.dy;

    a = sqrt(abval((nextx - stone->pos.x)*(nextx - stone->pos.x)) + abval((nexty - stone->pos.y)*(nexty - stone->pos.y)) );
    b = sqrt(abval((pos.x - stone->pos.x)*(pos.x - stone->pos.x)) + abval((pos.y - stone->pos.y)*(pos.y - stone->pos.y)) );
    c = sqrt(abval(move.dx*move.dx + move.dy*move.dy));

    textprintf(screen,font,0,20,makecol(0,0,255),"%f %f %f",a,b,c);
    readkey();

    cosa1 = ( acos(a*a - b*b - c*c)/(-2*b*c) );

    //stone->calc_new_vector( stone,(float)(cos(cos_a)*sqrt(move.dx*move.dx + move.dy*move.dy)) );

////////////////////////////////////////

    nextx = stone->pos.x + stone->move.dx;
    nexty = stone->pos.y + stone->move.dy;

    a = sqrt(abval((nextx - pos.x)*(nextx - pos.x)) + abval((nexty - pos.y)*(nexty - pos.y)) );
    b = sqrt(abval((stone->pos.x - pos.x)*(stone->pos.x - pos.x)) + abval((stone->pos.y - pos.y)*(stone->pos.y - pos.y)) );
    c = sqrt(abval(stone->move.dx*stone->move.dx + stone->move.dy*stone->move.dy));

    textprintf(screen,font,0,20,makecol(0,0,255),"%f %f %f",a,b,c);
    readkey();

    cosa2 = ( acos(a*a - b*b - c*c)/(-2*b*c) );

////////////////////////////////////////
    //stone->calc_new_vector( this,(cos(cosa1)*sqrt(move.dx*move.dx + move.dy*move.dy)) );
    //stone->calc_new_vector( stone,(cos(cosa2)*sqrt(stone->move.dx*stone->move.dx + stone->move.dy*stone->move.dy)) );

    float vi1 = (cos(cosa1)*sqrt(move.dx*move.dx + move.dy*move.dy);
    float vi2 = (cos(cosa2)*sqrt(stone->move.dx*stone->move.dx + stone->move.dy*stone->move.dy);

    float vf=(((mass - stone->mass)*vi)+(((1.0+(elac*stone->elac))*stone->mass)*stone->vi))/(mass+stone->mass);


    float angle=atan2(stone->pos.y - pos.y, stone->pos.x - pos.x); // angle of the line connecting the centers
    float sina=sin(angle);
    float cosa=cos(angle);
    float odx=cosa*vi1; // subtract off old velocity vector
    float ody=sina*vi1;
    float ndx=cosa*vf1; // add on new velocity vector
    float ndy=sina*vf1;
    float dx+=odx-ndx; // signs look reversed but are correct
    float dy+=ody-ndy;    */


}

float CStone::check_coll_with_stone(CStone *stone)
{
    float ret=-1;
    if(exist==1 && stone->exist==1)
        {
    //if(get_dist(pos , stone->pos) < radius + stone->radius) //they are colliding
    //if(pos.x

    /*
    0 = [(stone->move.dx - move.dx)^2 + (stone->move.dy - move.dy)^2] t^2 +
    [2(stone->pos.x - pos.x)(stone->move.dx - move.dx) + 2(stone->pos.y-pos.y)(stone->move.dy-move-dy)] t +
    [(stone->pos.x-pos.x)^2 + (stone->pos.y - pos.y)^2 - (radios + stone->radius)^2]
    */

    //elements for the quadratic equation
 /*   float a = ((stone->move.dx - move.dx)*(stone->move.dx - move.dx)) + ((stone->move.dy - move.dy),(stone->move.dy - move.dy));
    float b = 2*(stone->pos.x - pos.x)*(stone->move.dx - move.dx) + 2*(stone->pos.y-pos.y)*(stone->move.dy-move.dy);
    float c = ((stone->pos.x-pos.x),(stone->pos.x-pos.x)) + ((stone->pos.y - pos.y)*(stone->pos.y - pos.y)) - ((radius + stone->radius)*(radius + stone->radius));

    if(b*b >= 4*a*c) //must be the case so we don't try getting the sqrt of a neg number
        {
        float t1 = (-a + sqrt(b*b - 4*a*c)) / 2*a;
        float t2 = (-a - sqrt(b*b - 4*a*c)) / 2*a;

     //   move.dx=0;
     //   move.dy=0;

            textprintf(screen,font,0,10,makecol(0,255,0),"%f %f",t1,t2);
            readkey();

        if(t1>0 && t2>0)
            {
            float t;


            //the t I use is the smaller of the two
            if(t1<=t2)
                t = t1;
            else if(t2 < t1)
                t = t2;

            pos.x = pos.x + move.dx * t;
            pos.y = pos.y + move.dy * t;

            /////////
            move.dx=0;
            move.dy=0;
            /////////

            stone->pos.x = stone->pos.x + stone->move.dx * t;
            stone->pos.y = stone->pos.y + stone->move.dy * t;

            /////////
            stone->move.dx=0;
            stone->move.dy=0;
            /////////
            }
        }  */


    float temp1 = stone->move.dx - move.dx;
    float temp2 = stone->move.dy - move.dy;
    float a = temp1*temp1 + temp2*temp2;

    if (a != 0)
      {
        temp1 = 2.0 * (stone->pos.x - pos.x) * (stone->move.dx - move.dx);
        temp2 = 2.0 * (stone->pos.y - pos.y) * (stone->move.dy - move.dy);
        float b = temp1 + temp2;

        temp1 = stone->pos.x - pos.x;
        temp2 = stone->pos.y - pos.y;
        float temp3 = radius + stone->radius;
        float c = temp1*temp1 + temp2*temp2 - temp3*temp3;

        float radical = b*b - (4.0*a*c);

        if (radical >= 0)
            {
            radical = sqrt(radical);
            float twoa = 2.0 * a;
            float root1 = (-b + radical) / (twoa);
            float root2 = (-b - radical) / (twoa);

            if(root1>0 && root2>0 && (root1<1 || root2<1))
                {
                float t;
                if(root1<=root2)
                    t = root1;
                else if(root2 < root1)
                    t = root2;

                pos.x = pos.x + move.dx * t;
                pos.y = pos.y + move.dy * t;

                stone->pos.x = stone->pos.x + stone->move.dx * t;
                stone->pos.y = stone->pos.y + stone->move.dy * t;

                /*stone->pos.x = stone->pos.x + stone->move.dx;
                stone->pos.y = stone->pos.y + stone->move.dy;*/

                calc_new_vector(stone);
                ret=t;
                }
            }
        }
    }
    return ret;
}

#endif
